<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('company_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->string('firstname');
			$table->string('lastname', 255);
			$table->string('email', 255);
			$table->tinyInteger('type')->default('0');
			$table->string('password', 255);
			$table->string('phone', 255);
			$table->integer('AmountAllowed');
			$table->datetime('timemoney');
			$table->integer('currency_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}