<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransfersTable extends Migration {

	public function up()
	{
		Schema::create('transfers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('company_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->tinyInteger('status');
			$table->integer('user_id')->unsigned();
			$table->integer('payment_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('transfers');
	}
}