<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderPizzaToppingsTable extends Migration {

	public function up()
	{
		Schema::create('order_pizza_toppings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('order_pizza_id')->unsigned();
			$table->integer('pizza_id')->unsigned();
			$table->integer('topping_id')->unsigned();
			$table->decimal('unit_price');
			$table->integer('quantity');
			$table->decimal('amount')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_pizza_toppings');
	}
}