<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_pizzas', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_pizzas', function(Blueprint $table) {
			$table->foreign('pizza_id')->references('id')->on('pizzas')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_pizza_toppings', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_pizza_toppings', function(Blueprint $table) {
			$table->foreign('order_pizza_id')->references('id')->on('order_pizzas')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_pizza_toppings', function(Blueprint $table) {
			$table->foreign('pizza_id')->references('id')->on('pizzas')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('order_pizza_toppings', function(Blueprint $table) {
			$table->foreign('topping_id')->references('id')->on('toppings')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('order_pizzas', function(Blueprint $table) {
			$table->dropForeign('order_pizzas_order_id_foreign');
		});
		Schema::table('order_pizzas', function(Blueprint $table) {
			$table->dropForeign('order_pizzas_pizza_id_foreign');
		});
		Schema::table('order_pizza_toppings', function(Blueprint $table) {
			$table->dropForeign('order_pizza_toppings_order_id_foreign');
		});
		Schema::table('order_pizza_toppings', function(Blueprint $table) {
			$table->dropForeign('order_pizza_toppings_order_pizza_id_foreign');
		});
		Schema::table('order_pizza_toppings', function(Blueprint $table) {
			$table->dropForeign('order_pizza_toppings_pizza_id_foreign');
		});
		Schema::table('order_pizza_toppings', function(Blueprint $table) {
			$table->dropForeign('order_pizza_toppings_topping_id_foreign');
		});
	}
}