<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model 
{

    protected $table = 'transaction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function subscription()
    {
        return $this->hasOne('App\Subscription', 'subscription_id');
    }

    public function subtype()
    {
        return $this->hasOne('App\Subtype', 'subtype_id');
    }

    public function country()
    {
        return $this->hasOne('App\Country', 'ipcountry_id');
    }

}