<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Subscription extends Eloquent {

	protected $table = 'subscription';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function subtype()
	{
		return $this->hasOne('App\Subtype', 'subtype_id');
	}

	public function platform()
	{
		return $this->hasOne('App\Platform', 'platform_id');
	}

	public function country()
	{
		return $this->hasOne('App\Country', 'country_id');
	}

	public function user()
	{
		return $this->hasOne('App\User', 'user_id');
	}

}