<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transaction extends Eloquent {

	protected $table = 'transaction';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function subscription()
	{
		return $this->hasOne('App\Subscription', 'subscription_id');
	}

	public function subtype()
	{
		return $this->hasOne('App\Subtype', 'subtype_id');
	}

	public function country()
	{
		return $this->hasOne('App\Country', 'ipcountry_id');
	}

}