<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionTable extends Migration {

	public function up()
	{
		Schema::create('subscription', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('subtype_id')->unsigned();
			$table->integer('platform_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->boolean('active')->index();
			$table->enum('type', array('recurring', 'onetime', 'digitalpurchase'))->index();
		});
	}

	public function down()
	{
		Schema::drop('subscription');
	}
}