<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClubsTable extends Migration {

	public function up()
	{
		Schema::create('clubs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('company_name')->nullable();
			$table->string('logo')->nullable();
			$table->json('location')->nullable();
			$table->integer('satus_id')->unsigned();
			$table->integer('grade')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clubs');
	}
}