<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductDiscountTable extends Migration {

	public function up()
	{
		Schema::create('product_discount', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('product_id')->unsigned()->nullable();
			$table->integer('quantity')->nullable();
			$table->integer('priority')->nullable();
			$table->decimal('price', 8,4)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('product_discount');
	}
}