<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('length')->nullable();
			$table->date('date')->nullable();
			$table->integer('width')->nullable();
			$table->integer('partner_id')->nullable();
			$table->tinyInteger('type');
			$table->string('image', 250)->nullable();
			$table->string('video_url', 255)->nullable();
			$table->integer('period')->nullable();
			$table->string('video_title')->nullable();
			$table->string('image_title', 255)->nullable();
			$table->integer('show_count')->nullable();
			$table->tinyInteger('by_admin')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}