<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCharityTable extends Migration {

	public function up()
	{
		Schema::create('charity', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 250);
			$table->integer('country_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->string('address', 250)->nullable();
			$table->string('bank_account', 250)->nullable();
			$table->string('bank_photo', 250)->nullable();
			$table->integer('partner_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('charity');
	}
}