<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConventionTable extends Migration {

	public function up()
	{
		Schema::create('convention', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 250);
			$table->string('url', 250)->nullable();
			$table->integer('faculty_id')->unsigned()->nullable();
			$table->string('type')->nullable();
			$table->integer('copy_no')->nullable();
			$table->integer('university_id')->unsigned()->nullable();
			$table->string('university_boss', 250)->nullable();
			$table->string('faculty_dean', 250)->nullable();
			$table->date('date')->nullable();
			$table->tinyInteger('send_email')->nullable();
			$table->string('target', 250)->nullable();
			$table->text('details')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('convention');
	}
}