<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCurrencyTable extends Migration {

	public function up()
	{
		Schema::create('currency', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code', 250)->nullable();
			$table->string('symbol_left', 250)->nullable();
			$table->string('symbol_right', 250)->nullable();
			$table->decimal('value', 15,4)->nullable();
			$table->integer('status');
		});
	}

	public function down()
	{
		Schema::drop('currency');
	}
}