<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('invoice_no', 250)->nullable();
			$table->integer('parent_id')->nullable();
			$table->integer('customer_id');
			$table->text('comment')->nullable();
			$table->decimal('total', 15,4)->nullable();
			$table->integer('order_status_id')->nullable();
			$table->decimal('commission', 15,4)->nullable();
			$table->integer('marketing_id')->nullable();
			$table->integer('currency_id')->nullable();
			$table->integer('captain_id')->nullable();
			$table->integer('shipping_address_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}