<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('trips', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('from', 250)->nullable();
			$table->string('to', 250)->nullable();
			$table->date('date')->nullable();
			$table->decimal('amount', 15,4)->nullable();
			$table->integer('marketer_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('trip_type_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('trips');
	}
}