<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartTable extends Migration {

	public function up()
	{
		Schema::create('cart', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customer_id')->nullable();
			$table->integer('product_id')->nullable();
			$table->text('option')->nullable();
			$table->decimal('quantity', 15,4);
		});
	}

	public function down()
	{
		Schema::drop('cart');
	}
}