<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePressTable extends Migration {

	public function up()
	{
		Schema::create('press', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 250);
			$table->integer('country_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->string('logo', 250)->nullable();
			$table->string('address', 250);
			$table->integer('partner_id')->nullable();
			$table->string('license_photo', 250)->nullable();
			$table->string('license_no', 250)->nullable();
			$table->string('bank_account', 250)->nullable();
			$table->integer('marketer_id')->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('r_name')->nullable();
			$table->string('r_job', 250)->nullable();
			$table->string('r_email', 250)->nullable();
			$table->string('r_mobile', 250)->nullable();
			$table->integer('r_country_id')->nullable();
			$table->integer('r_city_id')->nullable();
			$table->string('r_address', 250)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('press');
	}
}