<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('type', 250)->nullable();
			$table->integer('star')->nullable();
			$table->integer('sender_id')->nullable();
			$table->string('sender_name', 250)->nullable();
			$table->string('subject', 250)->nullable();
			$table->integer('status')->nullable();
			$table->integer('marketer_id')->nullable();
			$table->text('descreption')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}