<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePressMessagesTable extends Migration {

	public function up()
	{
		Schema::create('press_messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('type', 250)->nullable();
			$table->integer('star')->nullable();
			$table->integer('sender_id')->unsigned()->nullable();
			$table->string('sender_name', 250)->nullable();
			$table->string('subject', 250)->nullable();
			$table->integer('status')->nullable();
			$table->integer('press_id')->unsigned();
			$table->text('description')->nullable();
			$table->integer('marketer_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('press_messages');
	}
}