<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePressVisitsTable extends Migration {

	public function up()
	{
		Schema::create('press_visits', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('marketer_id');
			$table->datetime('visit_date')->nullable();
			$table->string('reason', 250)->nullable();
			$table->text('descreption')->nullable();
			$table->integer('press_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('press_visits');
	}
}