<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingPricesTable extends Migration {

	public function up()
	{
		Schema::create('shipping_prices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('shipping_company_id')->unsigned()->nullable();
			$table->integer('from_c_id')->unsigned()->nullable();
			$table->integer('to_c_id')->unsigned()->nullable();
			$table->decimal('c1', 14.8)->nullable();
			$table->decimal('c2', 14.8)->nullable();
			$table->decimal('c3', 14.8)->nullable();
			$table->decimal('c4', 14.8);
			$table->decimal('c5')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_prices');
	}
}