<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingOrdersTable extends Migration {

	public function up()
	{
		Schema::create('shipping_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('shipping_company_id')->unsigned()->nullable();
			$table->integer('paymnent_method_id')->unsigned()->nullable();
			$table->decimal('weight')->nullable();
			$table->integer('product_id')->unsigned()->nullable();
			$table->integer('from_c_id')->unsigned();
			$table->integer('to_c_id')->unsigned()->nullable();
			$table->date('date')->nullable();
			$table->date('receive_date')->nullable();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->decimal('total', 14.8);
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_orders');
	}
}