<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('company_name', 255);
			$table->string('category', 255);
			$table->string('contact_person', 255);
			$table->text('address');
			$table->string('phone', 100);
			$table->string('fax', 100);
			$table->string('email', 100);
			$table->string('location', 255);
			$table->string('tin_no', 255);
			$table->tinyInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}