<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('employee_id', 100)->unique();
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->string('password', 255);
			$table->tinyInteger('status')->default('0');
			$table->date('date_of_birth');
			$table->string('personal_email', 100)->unique();
			$table->string('contact', 20);
			$table->string('resume', 255);
			$table->text('address');
			$table->string('token', 255);
			$table->date('date_of_joining');
			$table->string('remember_token', 100)->nullable();
			$table->integer('head');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}