<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug')->nullable();
			$table->string('name', 255)->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}