<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransfersTable extends Migration {

	public function up()
	{
		Schema::create('transfers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('beneficiary_user_id')->unsigned()->nullable();
			$table->integer('box_id')->unsigned()->nullable();
			$table->integer('sender_agency_id')->unsigned()->nullable();
			$table->integer('beneficiary_agency_id')->unsigned()->nullable();
			$table->integer('sender_customer_id')->unsigned()->nullable();
			$table->integer('beneficiary_customer_id')->unsigned()->nullable();
			$table->integer('beneficiary_country_id')->unsigned()->nullable();
			$table->integer('transfer_fee_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->string('anount')->nullable();
			$table->string('canceled', 10)->nullable()->default('0');
			$table->string('currency')->nullable();
			$table->string('commission')->nullable();
			$table->string('sending_code')->nullable();
			$table->string('receipt_code')->nullable();
			$table->string('transfer_fee_amount')->nullable();
			$table->timestamp('withdrawal_date')->nullable();
			$table->string('payment_method', 50)->nullable();
			$table->string('mobile_api_token', 255)->nullable();
			$table->string('status')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('transfers');
	}
}