<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->softDeletes();
			$table->string('slug');
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('nic_number', 255)->nullable();
			$table->string('passport_number')->nullable();
			$table->date('pass_expiry_date')->nullable();
			$table->string('type_identification')->nullable();
			$table->string('adresse')->nullable();
			$table->string('ville')->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}