<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExchangeFeesTable extends Migration {

	public function up()
	{
		Schema::create('exchange_fees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('default', 10)->nullable()->default('0');
			$table->softDeletes();
			$table->integer('currency_in_id')->unsigned()->nullable();
			$table->integer('currency_out_id')->unsigned();
			$table->string('slug')->nullable();
			$table->string('my_anount_buy')->nullable();
			$table->string('inter_amount_buy')->nullable();
			$table->string('nat_amount_buy')->nullable();
			$table->string('my_anount_sell', 255)->nullable();
			$table->string('nat_amount_sell', 255)->nullable();
			$table->string('inter_amount_sell')->nullable();
			$table->string('status')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('exchange_fees');
	}
}