<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Partner extends Eloquent {

	protected $table = 'partners';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'default_currency_id', 'slug', 'uv', 'cash', 'name', 'commission', 'commission_rate', 'status');
	protected $visible = array('country_id', 'default_currency_id', 'slug', 'uv', 'cash', 'name', 'commission', 'commission_rate', 'status');

	public function agencys()
	{
		return $this->hasMany('App\Models\Agency', 'partner_id');
	}

	public function commissions()
	{
		return $this->hasMany('App\Models\Commission', 'partner_id');
	}

	public function currency()
	{
		return $this->belongsTo('App\Models\Currency', 'default_currency_id');
	}

	public function reloadsUV()
	{
		return $this->hasMany('App\Models\ReloadUV', 'partner_id');
	}

	public function country()
	{
		return $this->belongsTo('App\Models\Country', 'country_id');
	}

	public function amountCashPartnersCurrencies()
	{
		return $this->hasMany('App\Models\AmountCashPartnersCurrencies', 'partner_id');
	}

}