<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PaymentCommission extends Eloquent {

	protected $table = 'payments_commissions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'commission_id', 'slug', 'anount', 'status');
	protected $visible = array('user_id', 'commission_id', 'slug', 'anount', 'status');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

	public function commission()
	{
		return $this->belongsTo('App\Models\Commission', 'commission_id');
	}

}