<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transfer extends Eloquent {

	protected $table = 'transfers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'beneficiary_user_id', 'box_id', 'sender_agency_id', 'beneficiary_agency_id', 'sender_customer_id', 'beneficiary_customer_id', 'beneficiary_country_id', 'transfer_fee_id', 'slug', 'anount', 'canceled', 'currency', 'commission', 'sending_code', 'receipt_code', 'transfer_fee_amount', 'withdrawal_date', 'payment_method', 'mobile_api_token', 'status');
	protected $visible = array('user_id', 'beneficiary_user_id', 'box_id', 'sender_agency_id', 'beneficiary_agency_id', 'sender_customer_id', 'beneficiary_customer_id', 'beneficiary_country_id', 'transfer_fee_id', 'slug', 'anount', 'canceled', 'currency', 'commission', 'sending_code', 'receipt_code', 'transfer_fee_amount', 'withdrawal_date', 'payment_method', 'mobile_api_token', 'status');

	public function transferFee()
	{
		return $this->belongsTo('App\Models\TransferFee', 'transfer_fee_id');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

	public function senderAgency()
	{
		return $this->belongsTo('App\Models\Agency', 'sender_agency_id');
	}

	public function sender()
	{
		return $this->belongsTo('App\Models\Customer', 'sender_customer_id');
	}

	public function box()
	{
		return $this->belongsTo('App\Models\Box', 'box_id');
	}

	public function beneficiary()
	{
		return $this->belongsTo('App\Models\Customer', 'beneficiary_customer_id');
	}

	public function beneficiaryAgency()
	{
		return $this->belongsTo('App\Models\Agency', 'beneficiary_agency_id');
	}

	public function beneficiaryCountry()
	{
		return $this->belongsTo('App\Models\Country', 'beneficiary_country_id');
	}

	public function beneficiaryUser()
	{
		return $this->belongsTo('App\Models\User', 'beneficiary_user_id');
	}

}