<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountrysTable extends Migration {

	public function up()
	{
		Schema::create('countrys', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('currency_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->string('short_name', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('iso_code', 10)->nullable();
			$table->string('phone_code', 10)->nullable();
			$table->string('flag', 255)->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('countrys');
	}
}