<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Interval extends Eloquent {

	protected $table = 'intervals';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'currency_id', 'slug', 'min', 'max', 'default', 'status');
	protected $visible = array('country_id', 'currency_id', 'slug', 'min', 'max', 'default', 'status');

	public function currency()
	{
		return $this->belongsTo('App\Models\Currency', 'currency_id');
	}

	public function country()
	{
		return $this->belongsTo('App\Models\Country', 'country_id');
	}

	public function transferFees()
	{
		return $this->hasMany('App\Models\TransferFee', 'interval_id');
	}

}