<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Job extends Eloquent {

	protected $table = 'jobs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'name', 'status');
	protected $visible = array('slug', 'name', 'status');

	public function users()
	{
		return $this->hasMany('App\Models\User', 'job_id');
	}

}