<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExchangesTable extends Migration {

	public function up()
	{
		Schema::create('exchanges', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('box_id')->unsigned()->nullable();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->integer('exchange_agency_id')->unsigned()->nullable();
			$table->integer('cashout_agency_id')->unsigned()->nullable();
			$table->integer('exchange_fee_id')->unsigned()->nullable();
			$table->integer('country_withdrawal_id')->unsigned()->nullable();
			$table->string('amount')->nullable();
			$table->string('currency')->nullable();
			$table->string('sending_code')->nullable();
			$table->string('slug')->nullable();
			$table->string('receipt_code')->nullable();
			$table->string('exchange_fee_amount')->nullable();
			$table->string('local_withdrawal', 10)->nullable()->default('0');
			$table->timestamp('withdrawal_date')->nullable();
			$table->string('motif')->nullable();
			$table->string('autre_motif')->nullable();
			$table->integer('sell')->nullable();
			$table->string('status')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('exchanges');
	}
}