<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AmountCashAgenciesCurrencies extends Eloquent {

	protected $table = 'amount_cash_agencies_currencies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('currency_id', 'agency_id', 'amount', 'status');
	protected $visible = array('currency_id', 'agency_id', 'amount', 'status');

	public function currency()
	{
		return $this->belongsTo('App\Models\Currency', 'currency_id');
	}

	public function agency()
	{
		return $this->belongsTo('App\Models\Agency', 'agency_id');
	}

}