<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Currency extends Eloquent {

	protected $table = 'currencys';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'name', 'iso_code', 'iso_numeric', 'symbol', 'smallest_denomination', 'status');
	protected $visible = array('slug', 'name', 'iso_code', 'iso_numeric', 'symbol', 'smallest_denomination', 'status');

	public function intervals()
	{
		return $this->hasMany('App\Models\Interval', 'currency_id');
	}

	public function exchangeInFees()
	{
		return $this->hasMany('App\Models\ExchangeFee', 'currency_in_id');
	}

	public function cashs()
	{
		return $this->hasMany('App\Models\Cash', 'currency_id');
	}

	public function countrys()
	{
		return $this->hasMany('App\Models\Country', 'currency_id');
	}

	public function partners()
	{
		return $this->hasMany('App\Models\Partner', 'default_currency_id');
	}

	public function agencies()
	{
		return $this->hasMany('App\Models\Agency', 'default_currency_id');
	}

	public function exchangeOutFees()
	{
		return $this->hasMany('App\Models\ExchangeFee', 'currency_out_id');
	}

	public function amountCashStatementCurrency()
	{
		return $this->hasMany('App\Models\AmountCashStatementCurrency', 'currency_id');
	}

	public function amountCashUserBoxCurrency()
	{
		return $this->hasMany('App\Models\AmountCashUserBoxCurrency', 'currency_id');
	}

	public function amountCashUsersCurrencies()
	{
		return $this->hasMany('App\Models\AmountCashUsersCurrencies', 'currency_id');
	}

	public function amountCashPartnersCurrencies()
	{
		return $this->hasMany('App\Models\AmountCashPartnersCurrencies', 'currency_id');
	}

	public function amountCashAgenciesCurrencies()
	{
		return $this->hasMany('App\Models\AmountCashAgenciesCurrencies', 'currency_id');
	}

	public function transferFees()
	{
		return $this->hasMany('App\Models\TransferFee', 'currency_id');
	}

}