<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartnersTable extends Migration {

	public function up()
	{
		Schema::create('partners', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('default_currency_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->string('uv')->nullable()->default('0');
			$table->string('cash')->nullable()->default('0');
			$table->string('name', 255)->nullable();
			$table->string('commission')->nullable();
			$table->string('commission_rate')->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('partners');
	}
}