<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Agency extends Eloquent {

	protected $table = 'agencys';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('partner_id', 'country_id', 'default_currency_id', 'slug', 'uv', 'cash', 'name', 'commission', 'alert_threshold', 'open_hour', 'close_hour', 'status', 'use_mobile_pay');
	protected $visible = array('partner_id', 'country_id', 'default_currency_id', 'slug', 'uv', 'cash', 'name', 'commission', 'alert_threshold', 'open_hour', 'close_hour', 'status', 'use_mobile_pay');

	public function users()
	{
		return $this->hasMany('App\Models\User', 'agency_id');
	}

	public function partner()
	{
		return $this->belongsTo('App\Models\Partner', 'partner_id');
	}

	public function senederTransfers()
	{
		return $this->hasMany('App\Models\Transfer', 'sender_agency_id');
	}

	public function exchangesCashin()
	{
		return $this->hasMany('App\Models\Exchange', 'exchange_agency_id');
	}

	public function boxes()
	{
		return $this->hasMany('App\Models\Box', 'agency_id');
	}

	public function commissions()
	{
		return $this->hasMany('App\Models\Commission', 'agency_id');
	}

	public function currency()
	{
		return $this->belongsTo('App\Models\Currency', 'default_currency_id');
	}

	public function beneficiaryTransfers()
	{
		return $this->hasMany('App\Models\Transfer', 'beneficiary_agency_id');
	}

	public function exchangesCashout()
	{
		return $this->hasMany('App\Models\Exchange', 'cashout_agency_id');
	}

	public function reloadsUV()
	{
		return $this->hasMany('App\Models\ReloadUV', 'agency_id');
	}

	public function country()
	{
		return $this->belongsTo('App\Models\Country', 'country_id');
	}

	public function amountCashAgenciesCurrencies()
	{
		return $this->hasMany('App\Models\AmountCashAgenciesCurrencies', 'agency_id');
	}

}