<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AmountCashPartnersCurrencies extends Eloquent {

	protected $table = 'amount_cash_partners_currencies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('partner_id', 'currency_id', 'amount', 'status');
	protected $visible = array('partner_id', 'currency_id', 'amount', 'status');

	public function currency()
	{
		return $this->belongsTo('App\Models\Currency', 'currency_id');
	}

	public function partner()
	{
		return $this->belongsTo('App\Models\Partner', 'partner_id');
	}

}