<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AmountCashStatementCurrency extends Eloquent {

	protected $table = 'amount_cash_statements_currencies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cash_statement_id', 'currency_id', 'amount', 'status');
	protected $visible = array('cash_statement_id', 'currency_id', 'amount', 'status');

	public function cashStatement()
	{
		return $this->belongsTo('App\Models\CashStatement', 'cash_statement_id');
	}

	public function currency()
	{
		return $this->belongsTo('App\Models\Currency', 'currency_id');
	}

}