<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AmountCashUsersCurrencies extends Eloquent {

	protected $table = 'amount_cash_users_currencies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'currency_id', 'amount', 'status');
	protected $visible = array('status');

	public function currency()
	{
		return $this->belongsTo('App\Models\Currency', 'currency_id');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

}