<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgencysTable extends Migration {

	public function up()
	{
		Schema::create('agencys', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('partner_id')->unsigned()->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('default_currency_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->string('uv')->nullable()->default('0');
			$table->string('cash')->nullable()->default('0');
			$table->string('name', 255)->nullable();
			$table->string('commission')->nullable()->default('0');
			$table->string('alert_threshold')->nullable()->default('0');
			$table->time('open_hour')->nullable();
			$table->time('close_hour')->nullable();
			$table->string('status', 10)->nullable()->default('0');
			$table->string('use_mobile_pay', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('agencys');
	}
}