<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGamesTable extends Migration {

	public function up()
	{
		Schema::create('games', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('developer');
			$table->bigInteger('submitter');
			$table->string('name');
			$table->string('slug');
			$table->string('tagline');
			$table->string('description');
			$table->string('website');
			$table->string('screenshot');
			$table->bigInteger('votes_up');
			$table->bigInteger('votes_down');
			$table->bigInteger('clicks_total');
			$table->bigInteger('clicks_unique');
			$table->timestamp('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('games');
	}
}