<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('term', 255)->nullable();
			$table->string('condition', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->string('logo', 255)->nullable();
			$table->decimal('min_limit_replacement', 10,2)->nullable();
			$table->integer('client_cash')->nullable();
			$table->decimal('max_commission', 10,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}