<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('SocialAccounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Likes', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('Events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Likes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Profiles', function(Blueprint $table) {
			$table->dropForeign('Profiles_user_id_foreign');
		});
		Schema::table('SocialAccounts', function(Blueprint $table) {
			$table->dropForeign('SocialAccounts_user_id_foreign');
		});
		Schema::table('Likes', function(Blueprint $table) {
			$table->dropForeign('Likes_event_id_foreign');
		});
		Schema::table('Likes', function(Blueprint $table) {
			$table->dropForeign('Likes_user_id_foreign');
		});
	}
}