<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('Events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 255)->unique();
			$table->string('url', 255)->unique();
			$table->string('photo', 255);
			$table->string('ticket_url', 255);
			$table->text('description');
			$table->string('location_name', 255);
			$table->string('lat', 255);
			$table->string('lng', 255);
			$table->date('event_starts_date');
			$table->date('event_starts_time');
			$table->date('event_ends_date');
			$table->time('event_ends_time');
			$table->enum('type_event', array(''));
			$table->enum('theme_event', array(''));
			$table->tinyInteger('private')->nullable();
			$table->enum('status', array(''))->nullable();
			$table->datetime('deleted_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Events');
	}
}