<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersDetailsTable extends Migration {

	public function up()
	{
		Schema::create('offers_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('course_id')->unsigned();
			$table->integer('offer_id')->unsigned()->nullable();
			$table->float('price_before_discount')->nullable()->default('0');
			$table->float('price_after_discount')->nullable()->default('0');
			$table->float('discount_rate')->nullable()->default('0');
			$table->datetime('datetime')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('offers_details');
	}
}