<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstructorsTable extends Migration {

	public function up()
	{
		Schema::create('instructors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('full_name', 55)->nullable();
			$table->string('bio', 255)->nullable();
			$table->string('photo', 255)->nullable();
			$table->string('phone_number', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('facebook', 400)->nullable();
			$table->string('twitter', 400)->nullable();
			$table->string('instagram', 400)->nullable();
			$table->string('youtube', 400)->nullable();
			$table->string('telegram', 400)->nullable();
			$table->string('martial_status', 25)->nullable();
			$table->string('nationality', 100)->nullable();
			$table->string('address', 400)->nullable();
			$table->text('skills_history')->nullable();
			$table->string('experiences_history', 400)->nullable();
			$table->text('working_history')->nullable();
			$table->string('notes', 400)->nullable();
			$table->string('rate', 55);
			$table->text('academic_history')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('instructors');
	}
}